function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 105);

T(1) = (params(2)-1)/params(2);
T(2) = (1-params(11))*exp(T(1)*y(44));
T(3) = exp(y(13))^params(3);
T(4) = exp(y(39));
T(5) = T(4)^(1-params(3));
T(6) = T(3)*T(5);
T(7) = T(6)^T(1);
T(8) = exp(y(36));
T(9) = T(2)*T(7)+params(11)*T(8)^T(1);
T(10) = params(2)/(params(2)-1);
T(11) = 1/params(2);
T(12) = exp(y(37))^T(11);
T(13) = (-1)/params(2);
T(14) = T(8)^T(13);
T(15) = T(12)*exp(T(1)*y(44))*(1-params(11))*(1-params(3));
T(16) = T(6)^T(13);
T(17) = T(4)^(-params(3));
T(18) = T(12)*exp(T(1)*y(44))*(1-params(11))*params(3);
T(19) = exp(y(13))^(params(3)-1);
T(20) = exp(y(38));
T(21) = params(9)^((-1)/params(8));
T(22) = 1/params(8);
T(23) = exp(y(40))-params(9)*T(4)^(1+params(8))/(1+params(8));
T(24) = T(23)^(-params(14));
T(25) = exp(y(15))-params(9)*exp(y(14))^(1+params(8))/(1+params(8));
T(26) = T(25)^(-params(14));
T(27) = params(13)^(1-params(4));
T(28) = params(12)^(1-params(4));
T(29) = T(24)*exp(y(22))*exp(y(25));
T(30) = params(21)^(-1);
T(31) = T(30)*y(18)*(-(exp(y(43))*exp(y(22))*exp(y(11))));
T(32) = exp(y(22))*y(54)+T(31)+T(30)*y(20)*(-(exp(y(22))*exp(y(43))));
T(33) = exp(y(22))*exp(y(25))-exp(y(25))*params(6)*exp(y(52)-y(45))^(params(5)-1);
T(34) = params(21)*y(105)*(-(exp(y(27))*exp((-y(93)))*exp(y(31))));
T(35) = exp(y(27))*y(66)+params(21)*y(98)*exp(y(27))*params(6)*exp(params(5)*(y(31)-y(93)))+params(21)*y(101)*(-(exp(y(27))*(1-exp((-y(93)))*exp(y(31)))))+T(34);
T(36) = params(21)*y(104)*(-(exp(y(32))*exp(y(28))));
T(37) = exp(y(28))*y(65)+params(21)*y(98)*params(6)*exp(params(5)*y(32))*exp(y(28))+params(21)*y(100)*(-((1-exp(y(32)))*exp(y(28))))+T(36);
T(38) = exp(y(29))*y(68)+y(66)*(-(params(7)*exp(y(29))))+params(21)*y(103)*(-((1-params(7))*exp(y(29))));
T(39) = exp(y(30))*y(67)+y(65)*(-(params(7)*exp(y(30))))+params(21)*y(102)*(-((1-params(7))*exp(y(30))));
T(40) = params(21)*y(101)*(-(exp(y(27))*(-(exp((-y(93)))*exp(y(31))))));
T(41) = T(34)+params(21)*y(98)*exp(y(27))*params(6)*params(5)*exp(params(5)*(y(31)-y(93)))+T(40);
T(42) = exp(y(91))*params(6)*params(5)*(params(5)-1)*exp(y(32)*(params(5)-1));
T(43) = (-(exp(y(91))*(exp(y(32))*exp(y(83))+y(84)*(-exp(y(32)))-params(6)*params(5)*exp(params(5)*y(32)))));
T(44) = params(21)*y(100)*(-(exp(y(28))*(-exp(y(32)))));
T(45) = T(8)*getPowerDeriv(T(8),T(13),1);
T(46) = T(8)*getPowerDeriv(T(8),T(1),1);
T(47) = getPowerDeriv(T(9),T(10),1);
T(48) = exp(y(37))*getPowerDeriv(exp(y(37)),T(11),1);
T(49) = exp(T(1)*y(44))*(1-params(11))*params(3)*T(48);
T(50) = exp(T(1)*y(44))*(1-params(11))*(1-params(3))*T(48);
T(51) = (1-params(11))*exp(T(1)*y(92));
T(52) = exp(y(88))^(1-params(3));
T(53) = T(20)*getPowerDeriv(T(20),params(3),1);
T(54) = T(20)^params(3);
T(55) = T(52)*T(54);
T(56) = getPowerDeriv(T(55),T(1),1);
T(57) = T(51)*T(52)*T(53)*T(56);
T(58) = T(55)^T(1);
T(59) = T(51)*T(58)+params(11)*exp(y(86))^T(1);
T(60) = getPowerDeriv(T(59),T(10),1);
T(61) = exp(y(88))^(-params(3));
T(62) = exp(y(87))^T(11);
T(63) = T(62)*(1-params(11))*(1-params(3))*exp(T(1)*y(92));
T(64) = T(55)^T(13);
T(65) = getPowerDeriv(T(55),T(13),1);
T(66) = T(52)*T(53)*T(65);
T(67) = T(20)^(params(3)-1);
T(68) = T(62)*(1-params(11))*params(3)*exp(T(1)*y(92));
T(69) = T(20)*getPowerDeriv(T(20),params(3)-1,1);
T(70) = (-(T(52)*(T(67)*T(66)*T(68)+T(64)*T(68)*T(69))));
T(71) = T(4)*getPowerDeriv(T(4),1+params(8),1);
T(72) = (-(params(9)*T(71)/(1+params(8))));
T(73) = getPowerDeriv(T(23),(-params(14)),1);
T(74) = T(72)*T(73);
T(75) = (1-params(3))*exp(y(39)*(1-params(3)));
T(76) = (-(exp(T(1)*y(44))*exp(y(13)*params(3))*T(75)));
T(77) = T(4)*getPowerDeriv(T(4),1-params(3),1);
T(78) = getPowerDeriv(T(6),T(13),1);
T(79) = T(3)*T(77)*T(78);
T(80) = (-(T(16)*T(18)*T(19)*T(77)+T(5)*T(19)*T(18)*T(79)));
T(81) = T(4)*getPowerDeriv(T(4),(-params(3)),1);
T(82) = (-(T(17)*T(3)*T(15)*T(79)+T(3)*T(15)*T(16)*T(81)));
T(83) = getPowerDeriv(T(6),T(1),1);
T(84) = T(2)*T(3)*T(77)*T(83);
T(85) = exp(y(89))-params(9)*exp(y(88))^(1+params(8))/(1+params(8));
T(86) = params(1)*T(85)^(-params(14));
T(87) = exp(y(40))*T(73);
T(88) = (-(params(1)*T(87)/T(26)));
T(89) = T(30)*y(17)*(-(exp(y(41))*exp(y(43))));
T(90) = exp(y(42))*getPowerDeriv(exp(y(42)),T(22),1);
T(91) = T(30)*y(20)*(exp(y(43))*params(6)*params(5)*exp(y(11)*(params(5)-1))-exp(y(43))*(exp(y(22))-y(34)))+exp(y(43))*y(60)+T(30)*y(17)*(-(exp(y(43))*(1+exp(y(41))-params(10))))+T(30)*y(18)*(-(exp(y(43))*(exp(y(22))*exp(y(11))+y(34)*(1-exp(y(11)))-params(6)*exp(params(5)*y(11)))))+T(30)*y(19)*(-(y(35)*exp(y(43))*(1-params(7))));
T(92) = T(12)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44));
T(93) = T(12)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44));
T(94) = (1-params(11))*T(1)*exp(T(1)*y(44));
T(95) = T(7)*T(94);
T(96) = params(21)^2;
T(97) = getPowerDeriv(exp(y(52)-y(45)),params(5)-1,1);
T(98) = (-(exp(y(25))*params(6)*(-exp(y(52)-y(45)))*T(97)));
T(99) = T(24)*T(98);
T(100) = (-(exp(y(6))*exp(y(10))*(-exp((-y(45))))));
T(101) = (-(exp(y(6))*(-(exp(y(10))*(-exp((-y(45))))))));
T(102) = exp(y(6))*params(6)*exp(params(5)*(y(10)-y(45)))*(-params(5));
T(103) = y(70)*T(100)+y(66)*T(101)+y(58)*T(102);
T(104) = (-(exp(y(25))*params(6)*exp(y(52)-y(45))*T(97)));
T(105) = exp(y(91))*params(6)*params(5)*exp(y(32)*(params(5)-1))-exp(y(91))*(exp(y(83))-y(84));

end
